package com.allinpay.demo.trx;

import com.allinpay.demo.AIPGException;
import com.allinpay.demo.DemoConfig;
import com.allinpay.demo.util.DemoUtil;
import com.allinpay.demo.util.HttpUtil;
import com.allinpay.demo.xml.XmlParser;
import com.allinpay.demo.xstruct.cardbin.QCardBinReq;
import com.allinpay.demo.xstruct.cardbin.QCardBinRsp;
import com.allinpay.demo.xstruct.common.AipgReq;
import com.allinpay.demo.xstruct.common.AipgRsp;
import com.allinpay.demo.xstruct.common.InfoReq;
import com.allinpay.demo.xstruct.common.InfoRsp;

/**
 * Bin200007 根据卡Bin获取银行卡信息
 * @author Mengjiaxin
 * @date 2022/4/18 下午1:14
 */
public class Bin200007 {

  /**
   * 根据银行卡号获得银行卡信息
   * @param acctNo
   * @return
   */
  public static QCardBinRsp getCardBin(String acctNo) {
    InfoReq infoReq = DemoUtil.makeReq("200007");
    QCardBinReq queryReq = new QCardBinReq();
    queryReq.setACCTNO(acctNo);

    AipgReq req = new AipgReq();
    req.setINFO(infoReq);
    req.addTrx(queryReq);

    try {
      //step1 对象转xml
      String xml = XmlParser.toXml(req);
      //step2 加签
      String signedXml = DemoUtil.buildSignedXml(xml);
      //step3 发往通联
      String url = DemoConfig.url + "?MERCHANT_ID=" + DemoConfig.merchantid + "&REQ_SN=" + infoReq.getREQ_SN();
      System.out.println("============================请求报文============================");
      System.out.println(signedXml);
      String respText = HttpUtil.post(signedXml, url);
      System.out.println("============================响应报文============================");
      System.out.println(respText);
      //step4 验签
      if (!DemoUtil.verifyXml(respText)) {
        System.out.println("====================================================>验签失败");
        return null;
      }
      System.out.println("====================================================>验签成功");
      //step5 xml转对象
      AipgRsp rsp = XmlParser.parseRsp(respText);
      InfoRsp infoRsp = rsp.getINFO();
      System.out.println(infoRsp.getRET_CODE());
      System.out.println(infoRsp.getERR_MSG());
      if ("0000".equals(infoRsp.getRET_CODE())) {
        QCardBinRsp ret = (QCardBinRsp) rsp.trxObj();
        System.out.println(ret.getBANKCODE());
        System.out.println(ret.getISSNAME());

        return ret;
      }
    } catch (AIPGException e) {
      e.printStackTrace();
    }

    return null;
  }

  public static void main(String[] args) {
    Bin200007.getCardBin("6230200202494980");
  }


}
