package com.allinpay.demo.trx;

import com.allinpay.demo.AIPGException;
import com.allinpay.demo.DemoConfig;
import com.allinpay.demo.util.AESUtil;
import com.allinpay.demo.util.DemoUtil;
import com.allinpay.demo.util.HttpUtil;
import com.allinpay.demo.xml.XmlParser;
import com.allinpay.demo.xstruct.common.AipgReq;
import com.allinpay.demo.xstruct.common.AipgRsp;
import com.allinpay.demo.xstruct.common.InfoReq;
import com.allinpay.demo.xstruct.common.InfoRsp;
import com.allinpay.demo.xstruct.trans.LedgerDtl;
import com.allinpay.demo.xstruct.trans.Ledgers;
import com.allinpay.demo.xstruct.trans.TransExt;
import com.allinpay.demo.xstruct.trans.TransRet;

/**
 * @Description 单笔实时代收
 * @Author meixf@allinpay.com
 * @Date 2018年5月29日
 **/
public class Tranx100011 {

	public static void main(String[] args){
		
		InfoReq infoReq = DemoUtil.makeReq("100011");
		
		TransExt trans = new TransExt();
		trans.setBUSINESS_CODE("10600");//必须使用业务人员提供的业务代码，否则返回“未开通业务类型”
		trans.setMERCHANT_ID(DemoConfig.merchantid);
		trans.setSUBMIT_TIME(DemoUtil.getNow());
		trans.setACCOUNT_NAME("林000000");
		trans.setACCOUNT_NO("622700034730729257");
		trans.setACCOUNT_PROP("0");
		trans.setAMOUNT("70000");
		trans.setBANK_CODE("0102");
		
		trans.setCURRENCY("CNY");
		/*trans.setREMARK("333");*/
		trans.setID_TYPE("5");
		trans.setID("4545454321215454");
		trans.setSUMMARY("摘要");
		trans.setCUST_USERID("xxxx分账");
		trans.setTEL("13226665872");
		trans.setNOTIFYURL("https://baidu");
		AipgReq req = new AipgReq();
				
		LedgerDtl dtl1 = new LedgerDtl();
		dtl1.setAMOUNT("9000");
		dtl1.setMERCHANT_ID("200604000006167");
		dtl1.setSN("0");
		dtl1.setTYPE("0");
		
		
		
		
     Ledgers ledgers = new Ledgers();
		ledgers.addTrx(dtl1);
		
		req.setINFO(infoReq);
		req.addTrx(trans);
	/*req.addTrx(ledgers);*/
		try{
			//step1 对象转xml
			String xml = XmlParser.toXml(req);
			//step2 加签
			
			String signedXml = DemoUtil.buildSignedXml(xml);
			//step3 发往通联
			String url = DemoConfig.url+"?MERCHANT_ID="+DemoConfig.merchantid+"&REQ_SN="+infoReq.getREQ_SN();
			System.out.println("============================请求报文============================");
			/*try {
				signedXml=AESUtil.encrptWithBase64(signedXml, "eYizakQ78DlXHc2mBEhNVpAp8fSlAx8j");
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}*/
			System.out.println(signedXml);
			
			String respText = HttpUtil.post(signedXml, url);
			
		/*	respText=AESUtil.decryptWithBase64(respText, "eYizakQ78DlXHc2mBEhNVpAp8fSlAx8j");*/
			System.out.println("============================响应报文============================");
			System.out.println(respText);
			//step4 验签
			if(!DemoUtil.verifyXml(respText)){
				System.out.println("====================================================>验签失败");
				return;
			}
			System.out.println("====================================================>验签成功");
			//step5 xml转对象
			AipgRsp rsp = XmlParser.parseRsp(respText);
			InfoRsp infoRsp = rsp.getINFO();
			System.out.println(infoRsp.getRET_CODE());
			System.out.println(infoRsp.getERR_MSG());
			if("0000".equals(infoRsp.getRET_CODE())){
				TransRet ret = (TransRet) rsp.trxObj();
				System.out.println(ret.getRET_CODE());
				System.out.println(ret.getERR_MSG());
				System.out.println(ret.getSETTLE_DAY());
				
			}
		}catch(AIPGException e){
			e.printStackTrace();
		}
	}
	
}
