package com.allinpay.demo.trx.account;

import java.util.ArrayList;
import java.util.List;

import com.allinpay.demo.AIPGException;
import com.allinpay.demo.DemoConfig;
import com.allinpay.demo.util.DemoUtil;
import com.allinpay.demo.util.HttpUtil;
import com.allinpay.demo.xml.XmlParser;
import com.allinpay.demo.xstruct.accttrans.AcctTransferReq;
import com.allinpay.demo.xstruct.accttransfer.BSum;
import com.allinpay.demo.xstruct.accttransfer.BacctTransferReq;
import com.allinpay.demo.xstruct.accttransfer.Dtl;
import com.allinpay.demo.xstruct.common.AipgReq;
import com.allinpay.demo.xstruct.common.AipgRsp;
import com.allinpay.demo.xstruct.common.InfoReq;
import com.allinpay.demo.xstruct.common.InfoRsp;
import com.allinpay.demo.xstruct.trans.ChargeReq;
import com.allinpay.demo.xstruct.trans.TransRet;
import com.allinpay.demo.xstruct.trans.brsp.Ret_Detail;


public class Tranx100401 {
	
	public static void main(String[] args){
		InfoReq infoReq = DemoUtil.makeReq("100401");
		
		BacctTransferReq chargeReq = new BacctTransferReq();
		BSum bSum =new BSum();
		bSum.setTOTAL_ITEM("1");
		bSum.setTOTAL_SUM("1");
		chargeReq.setBSUM(bSum);
		AipgReq req = new AipgReq();
		List<Dtl>list=new ArrayList<Dtl>();
		Dtl sDtl=new Dtl();
		sDtl.setAMOUNT("1");
		sDtl.setPAYEECUSID("200604000000445");
		sDtl.setSN("0001");
		list.add(sDtl);
		chargeReq.setDTLS(list);
		req.setINFO(infoReq);
		req.addTrx(chargeReq);
		
		try{
			//step1 对象转xml
			String xml = XmlParser.toXml(req);
			//step2 加签
			String signedXml = DemoUtil.buildSignedXml(xml);
			//step3 发往通联
			String url = DemoConfig.url+"?MERCHANT_ID="+DemoConfig.merchantid+"&REQ_SN="+infoReq.getREQ_SN();
			System.out.println("============================请求报文============================");
			System.out.println(signedXml);
			String respText = HttpUtil.post(signedXml, url);
			System.out.println("============================响应报文============================");
			System.out.println(respText);
			//step4 验签
			if(!DemoUtil.verifyXml(respText)){
				System.out.println("====================================================>验签失败");
				return;
			}
			System.out.println("====================================================>验签成功");
			//step5 xml转对象
			AipgRsp rsp = XmlParser.parseRsp(respText);
			InfoRsp infoRsp = rsp.getINFO();
			System.out.println(infoRsp.getRET_CODE());
			System.out.println(infoRsp.getERR_MSG());
			if("0000".equals(infoRsp.getRET_CODE())){
				com.allinpay.demo.xstruct.trans.brsp.Body rspBody = (com.allinpay.demo.xstruct.trans.brsp.Body)rsp.trxObj();
				@SuppressWarnings("unchecked")
				List<Ret_Detail> rspList = rspBody.getDetails();
				for(Ret_Detail rd : rspList){
					System.out.println(rd.getSN());
					System.out.println(rd.getRET_CODE());
					System.out.println(rd.getERR_MSG());
				}
			}
		}catch(AIPGException e){
			e.printStackTrace();
		}
	}
}
