package com.allinpay.demo.trx.ver;

import com.allinpay.demo.AIPGException;
import com.allinpay.demo.DemoConfig;
import com.allinpay.demo.util.DemoUtil;
import com.allinpay.demo.util.HttpUtil;
import com.allinpay.demo.xml.XmlParser;
import com.allinpay.demo.xstruct.common.AipgReq;
import com.allinpay.demo.xstruct.common.AipgRsp;
import com.allinpay.demo.xstruct.common.InfoReq;
import com.allinpay.demo.xstruct.common.InfoRsp;
import com.allinpay.demo.xstruct.ver.RNPA;
import com.allinpay.demo.xstruct.ver.RNPARET;

/**
 * @Description 实名付申请
 * @Author meixf@allinpay.com
 * @Date 2018年5月29日
 **/
public class Tranx211006 {

	public static void main(String[] args){
		InfoReq infoReq = DemoUtil.makeReq("211006");
		
		RNPA rnpa = new RNPA();
		rnpa.setMERCHANT_ID(DemoConfig.merchantid);
		rnpa.setACCOUNT_TYPE("00");
		rnpa.setACCOUNT_NO("6217002000028261982");
		rnpa.setACCOUNT_NAME("张玉杰");
		rnpa.setACCOUNT_PROP("0");
		rnpa.setID_TYPE("0");
		rnpa.setID("511321198801151956");
		rnpa.setTEL("15966666666");
		rnpa.setMERREM("20170908000000000012345");
	
		AipgReq req = new AipgReq();
		req.setINFO(infoReq);
		req.addTrx(rnpa);
		
		try{
			//step1 对象转xml
			String xml = XmlParser.toXml(req);
			//step2 加签
			String signedXml = DemoUtil.buildSignedXml(xml);
			//step3 发往通联
			String url = DemoConfig.url+"?MERCHANT_ID="+DemoConfig.merchantid+"&REQ_SN="+infoReq.getREQ_SN();
			System.out.println("============================请求报文============================");
			System.out.println(signedXml);
			String respText = HttpUtil.post(signedXml, url);
			System.out.println("============================响应报文============================");
			System.out.println(respText);
			//step4 验签
			if(!DemoUtil.verifyXml(respText)){
				System.out.println("====================================================>验签失败");
				return;
			}
			System.out.println("====================================================>验签成功");
			//step5 xml转对象
			AipgRsp rsp = XmlParser.parseRsp(respText);
			InfoRsp infoRsp = rsp.getINFO();
			System.out.println(infoRsp.getRET_CODE());
			System.out.println(infoRsp.getERR_MSG());
			if("0000".equals(infoRsp.getRET_CODE())){
				RNPARET ret = (RNPARET) rsp.trxObj();
				System.out.println(ret.getRET_CODE());
				System.out.println(ret.getERR_MSG());
			}
		}catch(AIPGException e){
			e.printStackTrace();
		}
	}
	
}
