package com.allinpay.demo.trx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import com.allinpay.demo.AIPGException;
import com.allinpay.demo.DemoConfig;
import com.allinpay.demo.util.DemoUtil;
import com.allinpay.demo.util.HttpUtil;
import com.allinpay.demo.xml.XmlParser;
import com.allinpay.demo.xstruct.common.AipgReq;
import com.allinpay.demo.xstruct.common.AipgRsp;
import com.allinpay.demo.xstruct.common.InfoReq;
import com.allinpay.demo.xstruct.common.InfoRsp;
import com.allinpay.demo.xstruct.netbank.NetBankReq;
import com.allinpay.demo.xstruct.netbank.NetBankRsp;


import sun.misc.BASE64Decoder;

public class BANK200006 {


	public static void main(String[] args) {
		InfoReq infoReq = DemoUtil.makeReq("200006");
		NetBankReq queryReq = new NetBankReq();
		/*queryReq.setBANKCODE("303");*/

		AipgReq req = new AipgReq();
		req.setINFO(infoReq);
		req.addTrx(queryReq);

		try{
			//step1 对象转xml
			String xml = XmlParser.toXml(req);
			//step2 加签
			String signedXml = DemoUtil.buildSignedXml(xml);
			//step3 发往通联
			String url = DemoConfig.url+"?MERCHANT_ID="+DemoConfig.merchantid+"&REQ_SN="+infoReq.getREQ_SN();
			System.out.println("============================请求报文============================");
			System.out.println(signedXml);
			String respText = HttpUtil.post(signedXml, url);
			System.out.println("============================响应报文============================");
			System.out.println(respText);
			//step4 验签
			/*if(!DemoUtil.verifyXml(respText)){
				System.out.println("====================================================>验签失败");
				return;
			}*/
			System.out.println("====================================================>验签成功");
			//step5 xml转对象
			AipgRsp rsp = XmlParser.parseRsp(respText);
			InfoRsp infoRsp = rsp.getINFO();
			System.out.println(infoRsp.getRET_CODE());
			System.out.println(infoRsp.getERR_MSG());
			if("0000".equals(infoRsp.getRET_CODE())){
				NetBankRsp ret = (NetBankRsp) rsp.trxObj();
					System.out.println(ret.getCONTENT());

				        try {
				        	FileOutputStream sos=null;
				    		sos=new FileOutputStream(new File("bills/zhifu.gz"));
				    		Base64InputStream b64is=new Base64InputStream(IOUtils.toInputStream(ret.getCONTENT()),false);
				    		IOUtils.copy(b64is, sos);
				    		IOUtils.closeQuietly(b64is);
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}


			}
		}catch(AIPGException e){
			e.printStackTrace();
		}
	}


}
