package com.allinpay.demo.trx;

import com.alibaba.fastjson.JSON;
import com.allinpay.demo.AIPGException;
import com.allinpay.demo.DemoConfig;
import com.allinpay.demo.util.DemoUtil;
import com.allinpay.demo.util.HttpUtil;
import com.allinpay.demo.xml.XmlParser;
import com.allinpay.demo.xstruct.cardbin.QCardBinReq;
import com.allinpay.demo.xstruct.cardbin.QCardBinRsp;
import com.allinpay.demo.xstruct.common.AipgReq;
import com.allinpay.demo.xstruct.common.AipgRsp;
import com.allinpay.demo.xstruct.common.InfoReq;
import com.allinpay.demo.xstruct.common.InfoRsp;

import java.util.Map;
import java.util.Objects;

/**
 * Bin200007 根据卡Bin获取银行卡信息
 * @author Mengjiaxin
 * @date 2022/4/18 下午1:14
 */
public class Bin200007 {

  /**
   * 根据银行卡号获得银行卡信息
   * @param acctNo
   * @return
   */
  public static QCardBinRsp getCardBin(String acctNo) {
    InfoReq infoReq = DemoUtil.makeReq("200007");
    QCardBinReq queryReq = new QCardBinReq();
    queryReq.setACCTNO(acctNo);

    AipgReq req = new AipgReq();
    req.setINFO(infoReq);
    req.addTrx(queryReq);

    try {
      //step1 对象转xml
      String xml = XmlParser.toXml(req);
      //step2 加签
      String signedXml = DemoUtil.buildSignedXml(xml);
      //step3 发往通联
      String url = DemoConfig.url + "?MERCHANT_ID=" + DemoConfig.merchantid + "&REQ_SN=" + infoReq.getREQ_SN();
      System.out.println("============================请求报文============================");
      System.out.println(signedXml);
      String respText = HttpUtil.post(signedXml, url);
      System.out.println("============================响应报文============================");
      System.out.println(respText);
      //step4 验签
      if (!DemoUtil.verifyXml(respText)) {
        System.out.println("====================================================>验签失败");
        return null;
      }
      System.out.println("====================================================>验签成功");
      //step5 xml转对象
      AipgRsp rsp = XmlParser.parseRsp(respText);
      InfoRsp infoRsp = rsp.getINFO();
      System.out.println(infoRsp.getRET_CODE());
      System.out.println(infoRsp.getERR_MSG());
      if ("0000".equals(infoRsp.getRET_CODE())) {
        QCardBinRsp ret = (QCardBinRsp) rsp.trxObj();
        // 需要在码表中匹配银行名称
        Map<Integer, String> bankCodeMap = getData();
        if(ret.getBANKCODE() != null && !Objects.equals("", ret.getBANKCODE())){
          Integer bankCode = Integer.valueOf(ret.getBANKCODE());
          if(bankCodeMap.containsKey(bankCode)){
            ret.setISSNAME(bankCodeMap.get(bankCode));
          }
        }

        System.out.println(ret.getBANKCODE());
        System.out.println(ret.getISSNAME());

        return ret;
      }
    } catch (AIPGException e) {
      e.printStackTrace();
    }

    return null;
  }



  public static void main(String[] args) {
    Bin200007.getCardBin("6222022304005114552");
  }

  /**
   * 通联的银行码表
   * @return
   */
  private static Map<Integer, String> getData(){
    String data = "{" +
            "102:\"中国工商银行\"," +
            "103:\"中国农业银行\"," +
            "104:\"中国银行\"," +
            "105:\"中国建设银行\"," +
            "201:\"国家开发银行\"," +
            "202:\"中国进出口银行\"," +
            "203:\"中国农业发展银行\"," +
            "301:\"交通银行\"," +
            "302:\"中信银行\"," +
            "303:\"中国光大银行\"," +
            "304:\"华夏银行\"," +
            "305:\"中国民生银行\"," +
            "306:\"广东发展银行\"," +
            "307:\"深圳发展银行\"," +
            "308:\"招商银行\"," +
            "309:\"兴业银行\"," +
            "310:\"上海浦东发展银行\"," +
            "313:\"城市商业银行\"," +
            "314:\"农村商业银行\"," +
            "315:\"恒丰银行\"," +
            "316:\"浙商银行\"," +
            "317:\"农村合作银行\"," +
            "318:\"渤海银行\"," +
            "319:\"徽商银行\"," +
            "401:\"城市信用社\"," +
            "402:\"农村信用社\"," +
            "403:\"中国邮政储蓄银行\"," +
            "501:\"汇丰银行\"," +
            "502:\"东亚银行\"," +
            "503:\"南洋商业银行\"," +
            "504:\"恒生银行(中国)有限公司\"," +
            "505:\"中国银行(香港)有限公司\"," +
            "506:\"集友银行有限公司\"," +
            "507:\"创兴银行有限公司\"," +
            "509:\"星展银行(中国)有限公司\"," +
            "510:\"永亨银行(中国)有限公司\"," +
            "512:\"永隆银行\"," +
            "531:\"花旗银行(中国)有限公司\"," +
            "532:\"美国银行有限公司\"," +
            "533:\"摩根大通银行(中国)有限公司\"," +
            "561:\"三菱东京日联银行(中国)有限公司\"," +
            "563:\"日本三井住友银行股份有限公司\"," +
            "564:\"瑞穗实业银行(中国)有限公司\"," +
            "565:\"日本山口银行股份有限公司\"," +
            "591:\"韩国外换银行股份有限公司\"," +
            "593:\"友利银行(中国)有限公司\"," +
            "594:\"韩国产业银行\"," +
            "595:\"新韩银行(中国)有限公司\"," +
            "596:\"韩国中小企业银行有限公司\"," +
            "597:\"韩亚银行(中国)有限公司\"," +
            "621:\"华侨银行(中国)有限公司\"," +
            "622:\"大华银行(中国)有限公司\"," +
            "623:\"星展银行(中国)有限公司\"," +
            "631:\"泰国盘谷银行(大众有限公司)\"," +
            "641:\"奥地利中央合作银行股份有限公司\"," +
            "651:\"比利时联合银行股份有限公司\"," +
            "652:\"比利时富通银行有限公司\"," +
            "661:\"荷兰银行\"," +
            "662:\"荷兰安智银行股份有限公司\"," +
            "671:\"渣打银行\"," +
            "672:\"英国苏格兰皇家银行公众有限公司\"," +
            "691:\"法国兴业银行(中国)有限公司\"," +
            "694:\"法国东方汇理银行股份有限公司\"," +
            "695:\"法国外贸银行股份有限公司\"," +
            "711:\"德国德累斯登银行股份公司\"," +
            "712:\"德意志银行(中国)有限公司\"," +
            "713:\"德国商业银行股份有限公司\"," +
            "714:\"德国西德银行股份有限公司\"," +
            "715:\"德国巴伐利亚州银行\"," +
            "716:\"德国北德意志州银行\"," +
            "732:\"意大利联合圣保罗银行股份有限公司\"," +
            "741:\"瑞士信贷银行股份有限公司\"," +
            "742:\"瑞士银行\"," +
            "751:\"加拿大丰业银行有限公司\"," +
            "752:\"加拿大蒙特利尔银行有限公司\"," +
            "761:\"澳大利亚和新西兰银行集团有限公司\"," +
            "771:\"摩根士丹利国际银行(中国)有限公司\"," +
            "775:\"联合银行(中国)有限公司\"," +
            "776:\"荷兰合作银行有限公司\"," +
            "781:\"厦门国际银行\"," +
            "782:\"法国巴黎银行(中国)有限公司\"," +
            "785:\"华商银行\"," +
            "787:\"华一银行\"," +
            "969:\"(澳门地区)银行\"," +
            "989:\"(香港地区)银行\"," +
            "3020000:\"中信实业银行\"," +
            "3136650:\"乐山商行\"," +
            "3138820:\"昆仑银行\"," +
            "4012900:\"上海银行\"," +
            "4021000:\"农信社(北京)\"," +
            "4023610:\"农信安徽\"," +
            "4023930:\"厦门市商业银行\"," +
            "4024210:\"江西农信社\"," +
            "4025350:\"湖北农信社\"," +
            "4025510:\"农信湖南\"," +
            "4031000:\"北京银行\"," +
            "4044560:\"烟台市商业银行\"," +
            "4053910:\"福州市商业银行\"," +
            "4062410:\"长春市商业银行\"," +
            "4073140:\"镇江市商业银行\"," +
            "4083320:\"宁波市商业银行\"," +
            "4083320:\"宁波银行\"," +
            "4094510:\"济南市商业银行\"," +
            "4105840:\"深圳平安银行\"," +
            "4115010:\"焦作市商业银行\"," +
            "4123330:\"温州市商业银行\"," +
            "4135810:\"广州市商业银行\"," +
            "4145210:\"武汉市商业银行\"," +
            "4162640:\"齐齐哈尔市商业银行\"," +
            "4172210:\"沈阳市商业银行\"," +
            "4184930:\"洛阳市商业银行\"," +
            "4192310:\"辽阳市商业银行\"," +
            "4202220:\"大连市商业银行\"," +
            "4213050:\"苏州市商业银行\"," +
            "4221210:\"石家庄市商业银行\"," +
            "4233310:\"杭州市商业银行\"," +
            "4243010:\"南京市商业银行\"," +
            "4243010:\"南京银行\"," +
            "4256020:\"东莞银行\"," +
            "4256020:\"东莞银行\"," +
            "4263380:\"金华市商业银行\"," +
            "4278810:\"乌鲁木齐市商业银行\"," +
            "4283370:\"绍兴市商业银行\"," +
            "4296510:\"成都市商业银行\"," +
            "4302240:\"抚顺市商业银行\"," +
            "4314730:\"临沂市商业银行\"," +
            "4325250:\"宜昌市商业银行\"," +
            "4332350:\"葫芦岛市商业银行\"," +
            "4341100:\"天津市商业银行\"," +
            "4354910:\"郑州市商业银行\"," +
            "4368710:\"银川市商业银行\"," +
            "4375850:\"珠海市商业银行\"," +
            "4384530:\"淄博市商业银行\"," +
            "4392270:\"锦州市商业银行\"," +
            "4403610:\"合肥市商业银行\"," +
            "4416530:\"重庆市商业银行\"," +
            "4422610:\"哈尔滨市商业银行\"," +
            "4437010:\"贵阳市商业银行\"," +
            "4447910:\"西安市商业银行\"," +
            "4453020:\"无锡市商业银行\"," +
            "4462260:\"丹东市商业银行\"," +
            "4478210:\"兰州市商业银行\"," +
            "4484220:\"南昌市商业银行\"," +
            "4484220:\"南昌银行\"," +
            "4491610:\"太原市商业银行\"," +
            "4504520:\"青岛市商业银行\"," +
            "4512420:\"吉林市商业银行\"," +
            "4523060:\"南通市商业银行\"," +
            "4533120:\"扬州市商业银行\"," +
            "4544240:\"九江市商业银行\"," +
            "4554732:\"日照市商业银行\"," +
            "4562230:\"鞍山市商业银行\"," +
            "4571260:\"秦皇岛市商业银行\"," +
            "4588510:\"西宁市商业银行\"," +
            "4593450:\"台州市商业银行\"," +
            "4603110:\"盐城市商业银行\"," +
            "4615510:\"长沙市商业银行\"," +
            "4624580:\"潍坊市商业银行\"," +
            "4634280:\"赣州市商业银行\"," +
            "4643970:\"泉州银行\"," +
            "4652280:\"营口市商业银行\"," +
            "4667310:\"昆明市商业银行\"," +
            "4672290:\"阜新市商业银行\"," +
            "4683040:\"常州市商业银行\"," +
            "4693080:\"淮安市商业银行\"," +
            "4703350:\"嘉兴市商业银行\"," +
            "4713620:\"芜湖市商业银行\"," +
            "4721460:\"廊坊市商业银行\"," +
            "4733450:\"台州市泰隆城市信用社\"," +
            "4741900:\"呼和浩特市商业银行\"," +
            "4753360:\"湖州市商业银行\"," +
            "4773650:\"马鞍山商业银行\"," +
            "4786110:\"南宁商业银行\"," +
            "4791920:\"包头商业银行\"," +
            "4803070:\"连云港商业银行\"," +
            "4814650:\"威海商业银行\"," +
            "4823660:\"淮北商业银行\"," +
            "4836560:\"攀枝花商业银行\"," +
            "4843680:\"安庆商业银行\"," +
            "4856590:\"绵阳商业银行\"," +
            "4856590:\"绵阳商行\"," +
            "4866570:\"泸州商业银行\"," +
            "4871620:\"大同商业银行\"," +
            "4885050:\"三门峡城市信用社\"," +
            "4901380:\"张家口商业银行\"," +
            "14012900:\"上海市农村信用社\"," +
            "14023052:\"昆山市农村信用社\"," +
            "14033055:\"常熟市农村信用社\"," +
            "14045840:\"深圳市农村信用社\"," +
            "14055810:\"广州市农村信用社\"," +
            "14063317:\"杭州市萧山区农村信用社\"," +
            "14075882:\"南海市农村信用社\"," +
            "14085883:\"顺德市农村信用社\"," +
            "14097310:\"昆明市农村信用社\"," +
            "14105210:\"武汉市农村信用社\"," +
            "14113030:\"徐州市市郊农村信用社\"," +
            "14136530:\"重庆市农村信用社\"," +
            "14144500:\"山东省市农村信用社\"," +
            "14144500:\"山东农信社\"," +
            "14144520:\"青岛农村信用社\"," +
            "14156020:\"东莞农村信用社\"," +
            "14163056:\"张家港市农村商业银行\"," +
            "14173930:\"厦门市农村信用社\"," +
            "14181000:\"北京农村信用联社\"," +
            "14191100:\"天津市农村信用社\"," +
            "14203320:\"宁波鄞州农村合作银行\"," +
            "14215881:\"佛山市三水区农村信用社\"," +
            "14226510:\"成都市农村信用社\"," +
            "14231440:\"沧州市农村信用社\"," +
            "14243000:\"江苏省农村信用社\"" +
            "}";
    return JSON.parseObject(data, Map.class);
  }

}
