package com.allinpay.demo.trx.contract;
import com.allinpay.demo.AIPGException;
import com.allinpay.demo.DemoConfig;
import com.allinpay.demo.util.DemoUtil;
import com.allinpay.demo.util.HttpUtil;
import com.allinpay.demo.xml.XmlParser;
import com.allinpay.demo.xstruct.common.AipgReq;
import com.allinpay.demo.xstruct.common.AipgRsp;
import com.allinpay.demo.xstruct.common.InfoReq;
import com.allinpay.demo.xstruct.common.InfoRsp;
import com.allinpay.demo.xstruct.quickpay.FAGRARET;
import com.allinpay.demo.xstruct.stdagr.AGRCNL;
import com.allinpay.demo.xstruct.stdagr.AGRCNLRSP;
import com.allinpay.demo.xstruct.stdagr.AGRINFO;
import com.allinpay.demo.xstruct.stdagr.AGRRSP;

public class Contract340003 {

	public static void main(String args[]){
		InfoReq inforeq = DemoUtil.makeReq("340003");
		
		AGRCNL fagra = new AGRCNL();
		fagra.setACCOUNT_NO("625781016999945858219");
		fagra.setAGRMNO("STD6146821910600190409000000002");
		fagra.setMERCHANT_ID(DemoConfig.merchantid);
		
		AipgReq req = new AipgReq();
		req.setINFO(inforeq);
		req.addTrx(fagra);
		try{
			//step1 对象转xml
			String xml = XmlParser.toXml(req);
			//step2 加签
			String signedXml = DemoUtil.buildSignedXml(xml);
			//step3 发往通联
			String url = DemoConfig.url+"?MERCHANT_ID="+DemoConfig.merchantid+"&REQ_SN="+inforeq.getREQ_SN();
			System.out.println("============================请求报文============================");
			System.out.println(signedXml);
			String respText = HttpUtil.post(signedXml, url);
			System.out.println("============================响应报文============================");
			System.out.println(respText);
			//step4 验签
			if(!DemoUtil.verifyXml(respText)){
				System.out.println("====================================================>验签失败");
				return;
			}
			System.out.println("====================================================>验签成功");
			//step5 xml转对象
			AipgRsp rsp = XmlParser.parseRsp(respText);
			InfoRsp infoRsp = rsp.getINFO();
			System.out.println(infoRsp.getRET_CODE());
			System.out.println(infoRsp.getERR_MSG());
			if("0000".equals(infoRsp.getRET_CODE())){
				AGRRSP fr = (AGRRSP)rsp.trxObj();
				System.out.println(fr.getRET_CODE());
				System.out.println(fr.getERR_MSG());
			}
		}catch(AIPGException e){
			e.printStackTrace();
		}
	}
}
