package com.allinpay.demo.trx.join;

import java.util.ArrayList;
import java.util.List;

import com.allinpay.demo.AIPGException;
import com.allinpay.demo.DemoConfig;
import com.allinpay.demo.util.DemoUtil;
import com.allinpay.demo.util.HttpUtil;
import com.allinpay.demo.xml.XmlParser;
import com.allinpay.demo.xstruct.common.AipgReq;
import com.allinpay.demo.xstruct.common.AipgRsp;
import com.allinpay.demo.xstruct.common.InfoReq;
import com.allinpay.demo.xstruct.common.InfoRsp;
import com.allinpay.demo.xstruct.trans.JointDtlDto;
import com.allinpay.demo.xstruct.trans.JointDto;
import com.allinpay.demo.xstruct.trans.Jointrans;
import com.allinpay.demo.xstruct.trans.TransRet;


public class Tranx100072 {


	public static void main(String[] args){
		
		InfoReq infoReq = DemoUtil.makeReq("100072");
		
		Jointrans trans = new Jointrans();
		trans.setBUSINESS_CODE("09900");//必须使用业务人员提供的业务代码，否则返回“未开通业务类型”
		trans.setMERCHANT_ID(DemoConfig.merchantid);
		trans.setSUBMIT_TIME(DemoUtil.getNow());
		trans.setACCOUNT_NAME("买单宝专用四307900");
		trans.setACCOUNT_NO("6217008340012565987");
		trans.setID("454547684646544");
		trans.setACCOUNT_PROP("0");
		trans.setAMOUNT("2601600");
		/*trans.setBANK_CODE("0102");*/
		trans.setCURRENCY("CNY");
		/*trans.setAGRMNO("AIP5987181018000001801");*/
		trans.setTEL("13226665872");
		JointDto i=new JointDto();
	
		JointDtlDto j=new JointDtlDto();
		
		j.setAMOUNT("2300800");
		j.setMERCHANT_ID("200604000005826");
		
		
		JointDtlDto k=new JointDtlDto();
		k.setAMOUNT("300800");
		k.setMERCHANT_ID("200604000005974");
		JointDtlDto l=new JointDtlDto();
		l.setAMOUNT("10");
		l.setMERCHANT_ID("200604000005826");
		/*i.addTrx(l);*/
	i.addTrx(k);
		i.addTrx(j);
		AipgReq req = new AipgReq();
		req.setINFO(infoReq);
		req.addTrx(trans);
		req.addTrx(i);
		try{
			//step1 对象转xml
			String xml = XmlParser.toXml(req);
			//step2 加签
			
			String signedXml = DemoUtil.buildSignedXml(xml);
			//step3 发往通联
			String url = DemoConfig.url+"?MERCHANT_ID="+DemoConfig.merchantid+"&REQ_SN="+infoReq.getREQ_SN();
			System.out.println("============================请求报文============================");
			System.out.println(signedXml);
			String respText = HttpUtil.post(signedXml, url);
			System.out.println("============================响应报文============================");
			System.out.println(respText);
			//step4 验签
			if(!DemoUtil.verifyXml(respText)){
				System.out.println("====================================================>验签失败");
				return;
			}
			System.out.println("====================================================>验签成功");
			//step5 xml转对象
			AipgRsp rsp = XmlParser.parseRsp(respText);
			InfoRsp infoRsp = rsp.getINFO();
			System.out.println(infoRsp.getRET_CODE());
			System.out.println(infoRsp.getERR_MSG());
			if("0000".equals(infoRsp.getRET_CODE())){
				TransRet ret = (TransRet) rsp.trxObj();
				System.out.println(ret.getRET_CODE());
				System.out.println(ret.getERR_MSG());
				System.out.println(ret.getSETTLE_DAY());
				
			}
		}catch(AIPGException e){
			e.printStackTrace();
		}
	}
	

}
